unit unDSP;

interface

uses
  Windows, Classes, Controls, StdCtrls,Forms, ComCtrls;


type
  TSocketState = (stClosed,stConnected,stLoggingOn,stLoggedIn);
  TfoDSP = class(TForm)
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


type
	PShortInt = ^ShortInt;
        TShortData      = Array [ 0 ..20000] of Smallint ;
        PShortData      = ^TShortData {TShortData };

//---------------------------------------------------------------------------------------------------------
 PDSP_Module = ^TDSP_Module ;
 TDSP_Module = record
	    description:PChar;			// description of module, with version string
            hMainWindow:integer;		// winamp's main window (filled in by winamp)
	    hDllInstance:integer;		// DLL instance handle (filled in by winamp)

            Config                  : Procedure ( This_Mod : PDSP_Module ) ; cdecl ;
            Init                    : Function ( This_Mod : PDSP_Module ) : Integer ; cdecl ;
            ModifySamples           : Function ( This_Mod : PDSP_Module ; Samples : PShortData; numsamples, bps, nch, srate : Integer):Integer; cdecl;

            Quit                    : Procedure ( This_Mod : PDSP_Module ) ; cdecl ;
            UserData                : Pointer ;
 end;

 PDSP_Header = ^TDSP_header ;
 TDSP_header = Record
   Version              : Integer ;
   Description          : PChar ;
   GetModule            : Function ( I : Integer ) : PDSP_Module ; cdecl ;
 End ;


//---------------------------------------------------------------------------------------------------------


	function winampDSPGetHeader2 : PDSP_Header; cdecl; export;

        function GetModule(I : Integer) : PDSP_Module; cdecl;

	procedure config( This_Mod : PDSP_Module ); cdecl;
	function init( This_Mod : PDSP_Module ):Integer; cdecl;
	procedure quit ( This_Mod : PDSP_Module ); cdecl;
	function ModifySamples( This_Mod : PDSP_Module; Samples : PShortData; numsamples, bps, nch, srate : Integer ) : Integer; cdecl;

Type TGetModule = Function ( Which : Integer ) : PDSP_Module ; cdecl ;


const
        DSP_Ver = $20;
        PI_VER = 'v1.0';
        OurDescription = 'DSP Demo plugin '+PI_VER;

	WinampDSPHeader : TDSP_header =
	(
		Version     : DSP_VER;
                Description : OurDescription;
                GetModule   : GetModule;
	);

        WinampDSP1 : TDSP_Module =
        (
	    description : 'DSP Pitch shift';
            hMainWindow : 0;
	    hDllInstance: 0;

            Config                  : config;
            Init                    : Init;
            ModifySamples           : ModifySamples;
            Quit                    : Quit;
            UserData                : nil ;
        );


var
  foDSP        : TfoDSP = nil;
  ThisInstance : Hinst;
  MainHwnd     : HWnd;

  g_pitch      : Integer = 100;
  pitch_buffer : PShortData;
implementation

{$R *.DFM}

 //This code was take from an SDK
function  OurMessageBox(Owner :Integer; Msg, Title :string; Style :integer) :integer;
          {Makes a message box with a style of STYLE}
          {MB_OK = OK button}
          {MB_OKCANCEL = OK and Cancel buttons}
          {Returns an ID (0 = ID_OK)}
          begin
          Msg := Msg + #0;
          Title := Title + #0;
          Result := MessageBox(Owner,@Msg[1],@Title[1],Style);
          end;


{==========================================================================}
Function GetModule( I : Integer ) : PDSP_Module ; cdecl ;
begin
 Case I of
  0 : Result := @WinampDSP1;
  else Result := nil;
 end;
end;

procedure config( This_Mod : PDSP_Module ); cdecl;
begin
 OurMessageBox (This_Mod.hMainWindow, '! There is nothing to configure for this plug-in !' + #13 +
                    'for updates check http://www.MindBlastSoftware.com/' ,
                    'Plugin by Louis, MindBlast Software' , mb_ok or mb_iconinformation ) ;
end;

function init( This_Mod : PDSP_Module ):Integer; cdecl;
Begin
//  Application.CreateHandle;

  new(pitch_buffer);

  ThisInstance := This_Mod.hDLLinstance;
  MainHwnd := This_Mod.hMainWindow;

  If foDSP = Nil then
    Begin
      Application.CreateHandle;
      Application.CreateForm(TfoDSP,foDSP);
    End;
  foDSP.Show ;

 Result := 0;
end;

procedure quit ( This_Mod : PDSP_Module ); cdecl;
Begin
   foDSP.Free ; foDSP := Nil ;

   dispose(pitch_buffer);
end;


function ModifySamples( This_Mod : PDSP_Module; Samples : PShortData; numsamples, bps, nch, srate : Integer ) : Integer; cdecl;
(* Code by Justin from NullSoft *)
(* Converted to Delphi by Louis *)
var
 pitch,
 rlen,
 index,
 x,
 n,
 dindex,p       : Integer;
begin
	rlen  := numsamples*(bps div 8)*nch;
	index :=0;

        pitch := g_pitch;

	if (pitch=100) then
         begin
          Result := numsamples;
          Exit;
         end;

	if (pitch > 200) then pitch := 200;
	if (pitch < 50) then pitch := 50;

	pitch := round(100000/pitch);

	n := round((numsamples*pitch)/1000);

	dindex :=(numsamples shl 14) div n;

	if (bps = 16) AND (nch = 2) then
        begin
		Move(samples^[0],pitch_buffer^[0],rlen);
                x:=0;
                while x<n do
                begin
			p := (index shr 14) shl 1;
			index := index + dindex;
			samples[x] := pitch_buffer[p];
			samples[x+1] := pitch_buffer[p+1];

                        inc(x);
		end;
		result := n;
                exit;
	end
	else if (bps = 16) and (nch = 1) then
        begin
                Move(samples^[0],pitch_buffer^[0],rlen);
                x:=0;
                while x<n do
                begin
			p :=(index shr 14);
                        index := index + dindex;
                        samples[x] := pitch_buffer[p];
                  inc(x);
		end;
		result := n;
                exit;
        end;

     result := numsamples;

end;


function winampDSPGetHeader2 : PDSP_Header; cdecl;
begin
 Result := @WinampDSPHeader;
end;

procedure TfoDSP.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action := caNone;
end;

procedure TfoDSP.TrackBar1Change(Sender: TObject);
begin
 g_pitch := TrackBar1.Position;
end;

end.
